/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.myrrix.common.collection.FastIDSet;
import org.apache.mahout.cf.taste.recommender.IDRescorer;

public final class ExampleRescorer
implements IDRescorer {
    private FastIDSet someCurrentIDs;

    public ExampleRescorer() {
        int reloadMinutes = 15;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());
        executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ExampleRescorer.this.doLoad();
            }
        }, reloadMinutes, reloadMinutes, TimeUnit.MINUTES);
        this.doLoad();
    }

    private void doLoad() {
        FastIDSet newIDs = new FastIDSet();
        newIDs.add(1L);
        this.someCurrentIDs = newIDs;
    }

    @Override
    public double rescore(long itemID, double rawValue) {
        return this.someCurrentIDs.contains(itemID) ? rawValue : Double.NaN;
    }

    @Override
    public boolean isFiltered(long itemID) {
        return !this.someCurrentIDs.contains(itemID);
    }
}

