% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmeans_NumeroOtimo2.R
\name{Kmeans_NumeroOtimo2}
\alias{Kmeans_NumeroOtimo2}
\title{Numero otimo de clusters pelo metodo do cotovelo}
\usage{
Kmeans_NumeroOtimo2(Dados,design=1,nboot=100, Metodo=1,iter.max = 100,
NumMax=NULL,TituloX="Numero de clusters",TituloY=NULL,Theme=theme_classic())
}
\arguments{
\item{Dados}{Matriz contendo os dados para execucao da analise. Para cada
modelo o conjunto de dados precisa estar organizado de uma forma apropriada:
\itemize{ \item Design 1: Deve ter apenas os dados numericos da pesquisa.
 Na primeira linha não deve ter o nome dos individuos/tratamentos.
  \item Design 2 e 3: As duas primeiras colunas devem conter a
identificacao dos tratamentos e repeticoes/blocos, e as demais os valores
observanos nas variaveis respostas. \item Modelo 4: As tres primeiras
colunas devem conter as informacoes dos tratamentos, linhas e colunas, e
posteriormente, os valores da variavel resposta. \item Modelos 5 e 6: as
primeiras colunas precisam ter a informacao do fator A, fator B,
repeticao/bloco, e posteriormente, as variaveis respostas.}}

\item{design}{Valor numerico indicando o delineamento:
\itemize{
\item 1 =  Experimento sem repeticoes.
\item 2 =  Delineamento inteiramente casualizado (DIC) .
 \item 3 = Delineamento em blocos casualizados (DBC).
 \item 4 = Delineamento em quadrado latino (DQL).
  \item 5 =Esquema fatorial duplo em DIC.
  \item 6 = Esquema fatorial duplo em DBC.}}

\item{nboot}{numero de reamostragens desejadas para o metodo bootstrap.}

\item{Metodo}{Criterio utilizado para a estimacao do numero otimo de clusters.
Pode-se utilizar as seguintes opcoes:
\itemize{
\item  1 = Metodo baseado na porcentagem de explicacao
\item 2 = Metodo baseado na soma dos quadrados intra-cluster
 \item 3 =  = Metodo baseado na soma dos quadrados inter-cluster
}}

\item{iter.max}{numero de reamostragens desejadas para o metodo bootstrap.}

\item{NumMax}{Numero maximo de clustes a ser considerado (Obs: Deve ser no minimo 2).}

\item{TituloX}{Titulo desejado para o eixo x.}

\item{TituloY}{Titulo desejado para o eixo y.}

\item{Theme}{Tema utilizado para o graficos do `ggplot2` (Ex.:theme_gray(),
theme_bw(), theme_linedraw(), theme_light(), theme_dark(), theme_minimal(),
theme_classic(), theme_void(), theme_test()).}
}
\value{
A funcao retorna o numero otimo de clusters a ser considerado no metodo kmeans.
}
\description{
Esta funcao retorna o numero otimo de clusters para o metodo kmeans
 considerando dieferentes criterios.
 @name Kmeans_NumeroOtimo2
}
\examples{
#Sem repeticoes
data("Dados.MED")
Dados=Dados.MED
rownames(Dados)=paste("Genotipo",1:10,sep="_")
Kmeans_NumeroOtimo2(Dados,design=1,nboot=100,iter.max = 100,NumMax=NULL)

#Experimento em DIC
data("Dados.DIC")
Dados=Dados.DIC
Kmeans_NumeroOtimo2(Dados,design=2,Metodo = 2,nboot=100,iter.max = 100,NumMax=NULL)

#Experimento em DBC
data("Dados.DBC")
Dados=Dados.DBC
Kmeans_NumeroOtimo2(Dados,design=3,nboot=100,iter.max = 100,NumMax=NULL)

#Experimento em DQL
data("Dados.DQL")
Dados=Dados.DQL
Kmeans_NumeroOtimo2(Dados,design=4,nboot=100,iter.max = 100,NumMax=NULL)

#Experimento em fatorial no DIC
data("Dados.Fat2.DIC")
Dados=Dados.Fat2.DIC
Kmeans_NumeroOtimo2(Dados,design=5,Metodo = 1,nboot=100,iter.max = 100,NumMax=NULL)
Kmeans_NumeroOtimo2(Dados,design=5,Metodo =2,nboot=100,iter.max = 100,NumMax=NULL)
Kmeans_NumeroOtimo2(Dados,design=5,Metodo =3,nboot=100,iter.max = 100,NumMax=NULL)

#Experimento em fatorial no DBC
data("Dados.Fat2.DBC")
Dados=Dados.Fat2.DBC
Kmeans_NumeroOtimo2(Dados,design=5,Metodo = 1,nboot=100,iter.max = 100,NumMax=NULL)
Kmeans_NumeroOtimo2(Dados,design=5,Metodo =2,nboot=100,iter.max = 100,NumMax=NULL)
Kmeans_NumeroOtimo2(Dados,design=5,Metodo =3,nboot=100,iter.max = 100,NumMax=NULL)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{Kmeans}}, \code{\link{Kmeans_NumeroOtimo2}} , \code{\link{ContribuicaoRelativa}}
}
