% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-documentation.R
\docType{data}
\name{MultiATSM_datasets}
\alias{MultiATSM_datasets}
\title{Overview of Datasets Included in the MultiATSM Package}
\description{
The package includes several pre-processed datasets used for estimation and replication examples:
}
\details{
\describe{
  \item{GlobalMacro}{Global macro-financial risk factors, namely global economic activity and global inflation.}
  \item{GlobalMacro_covid}{Global macro-financial risk factors, namely the output growth rate from the U.S. and China and the S&P 500 index.}
  \item{DomMacro}{Domestic macroeconomic risk factors, namely economic activity and inflation.}
  \item{DomMacro_covid}{Domestic macroeconomic risk factors, namely otput growth, inflation, CDS and the COVID-19 reproduction rate}
  \item{TradeFlows}{Bilateral trade flow series used in GVAR examples as a proxy measure of cross-country conectdness.}
  \item{TradeFlows_covid}{Bilateral trade flow series used in GVAR examples as a proxy measure of cross-country conectdness.}
  \item{Yields}{Monthly series of bond yields by maturity for multiple economies.}
  \item{Yields_covid}{Weekly series of sovereign bond yields by maturity for multiple economies.}
  \item{RiskFacFull}{Full set of risk factors (global and domestic) data used throughout the package}
  \item{GVARFactors}{List of risk factors used in the estimation of GVAR models.}
  \item{BR_jps_out}{Replications of the JPS outputs by Bauer and Rudebusch (2017)}
  \item{InpForOutEx}{List of inputs for an illustrative JPS model with Brazilian data}
  \item{ParaSetEx}{List of set of parameterafter optimization for an illustrative JPS model with Brazilian data}
  \item{NumOutEx}{List of numerical outputs for an illustrative JPS model with Brazilian data}
  \item{Out_Example}{re-loaded examaple of a complete list of several model outputs. Used in the package vignette.}
}

Each dataset is documented separately using `?GlobalMacro`, `?DomMacro`, `?TradeFlows`, `?Yields`, etc.
Datasets ending with the suffix \code{_covid} are based on those used in Candelon and Moura (2023) and cover Brazil, India, Mexico, and Russia.
The remaining datasets correspond to Candelon and Moura (2024) and include Brazil, China, Mexico, and Uruguay.
}
\references{
\enumerate{
\item Candelon, B. and Moura, R. (2023) "Sovereign yield curves and the COVID-19 in emerging markets". (Economic Modelling)
\item Candelon, B. and Moura, R. (2024) "A Multicountry Model of the Term Structures of Interest Rates with a GVAR". (Journal of Financial Econometrics)
}
}
