% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terpstrapower.R
\name{terpstrapower}
\alias{terpstrapower}
\title{Power for the nonparametric Terpstra test for an ordered effect.}
\usage{
terpstrapower(
  nreps,
  shifts,
  distname = c("normal", "logistic"),
  level = 0.025,
  mc = 0
)
}
\arguments{
\item{nreps}{The numbers in each group.}

\item{shifts}{The offsets for the various populations, under the alternative hypothesis.}

\item{distname}{The distribution of the underlying observations; normal and logistic are currently supported.}

\item{level}{The test level.}

\item{mc}{Zero indicates asymptotic calculation.  Positive for MC calculation.}
}
\value{
A list with components power, giving the power approximation, expect, giving null and alternative expectations, var, giving the null variance, probs, giving the intermediate output from pairwiseprobability, and level.
}
\description{
\code{terpstrapower} approximates power for the one-sided Terpstra test, 
using a normal approximation with expectations under the null and alternative, and using the null standard deviation.
}
\details{
The standard normal-theory power formula is used.
}
\examples{
terpstrapower(rep(10,3),c(0,1,2),"normal")
terpstrapower(c(10,10,10),0:2,"normal",mc=1000)
}
