% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_timecourse.R
\name{normalize_timecourse}
\alias{normalize_timecourse}
\title{Normalizes a time course using a given mapping from integration sites to
clones.}
\usage{
normalize_timecourse(readouts, rec, rec_first = FALSE, reduce_clones = TRUE)
}
\arguments{
\item{readouts}{The integration site readouts to adjust.}

\item{rec}{A matrix with columns "IS" and "Clone" that assigns each
integration site to a clone.}

\item{rec_first}{Whether the clones should be put in the first rows of the
resulting time course.}

\item{reduce_clones}{Whether to represent the integration sites by their
respective clone.}
}
\value{
The adjusted time course.
}
\description{
Each integration site is replaced by its clone. The size of the clone is
adjusted to be the mean size of the integration sites within it. For
integration sites that are not mentioned in `rec`, we adjust by the average
number of integration sites per clone.
}
