% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axKeyfitz.R
\name{axKeyfitz}
\alias{axKeyfitz}
\title{A Nathan Keyfitz approximation of Chiang's a(x), average number of years lived by persons dying in the interval x,x+n.}
\usage{
axKeyfitz(Mx, n, axsmooth = TRUE)
}
\arguments{
\item{Mx}{numeric vector of the age-specific central death rates, calculated as D(x)/N(x) (deaths/exposure)}

\item{n}{a numeric vector of age interval widths.}

\item{axsmooth}{logical. default = \code{TRUE}. Should the a(x) values be calculated from a smoothed M(x) series? In this case, the M(x) series is smoothed within the function for a(x) estimation, but the smoothed M(x) function that was used is not returned. In general, it is better to smooth the M(x) function prior to putting it in this function, because the loess smoother used here has no weights or offset. If this is not possible, loess M(x) smoothing still produces more consistent and less erratic a(x) estimates.}
}
\value{
returns \code{ax}, a numeric vector of a(x) values.
}
\description{
An iterative approximation of Chiang's a(x), as proposed by Nathan Keyfitz (1966) and described in Preston (2001).
}
\details{
This procedure usually converges very quickly. First, dx is estimated from an ax vector of interval midpoints (except age 0, which is ignored in this process. This d(x) is used to estimate another a(x) based on d(x) slopes. Repeat 7 times. The Keyfitz iterative procedure provides no estimates for the final two ages. These I impute (see last part of code, below) based on the a(x) slope for the last estimated interval. In the penultimate interval, this increment is multiplied by 1.5, and again multiplied by 1.5 for the final a(x) value, which has the effect of exaggerating the tendency at the end of the series.
}
\note{
Preston warns that this method should only be used when the age intervals are equal, which is not the case with abridged data. The function will still estimate using such data, but be wary.
}
\author{
Tim Riffe
}
\references{
Chiang C.L.(1968) Introduction to Stochastic Processes in Biostatistics. New York: Wiley.
Keyfitz, Nathan (1966) A Life Table that Agrees with the Data. Journal of the American Statistical Association, 61 (314):305-12. (As described on page 44-45 of Preston et al (2001). Demography: Measuring and Modelling Population Processes. Blackwell Publishing)
}
\seealso{
\code{\link{axEstimate}}, a wrapper function for this and three other a(x) estimation procedures (\code{\link{axMidpoint}}, \code{\link{axSchoen}} and \code{\link{axPreston}}).
}

