% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MortCast-data.R
\docType{data}
\name{MLTlookup}
\alias{MLTlookup}
\alias{MLT1Ylookup}
\title{Model Life Tables Lookup}
\format{
Data frame with the following columns:
\describe{
\item{type}{Type of the model life table. Available options are \dQuote{CD_East}, \dQuote{CD_North}, 
\dQuote{CD_South}, \dQuote{CD_West}, \dQuote{UN_Chilean}, \dQuote{UN_Far_Eastern}, 
\dQuote{UN_General}, \dQuote{UN_Latin_American}, \dQuote{UN_South_Asian}. 
For the CD types, see Coale et al. (1983). For the UN types, see the link in References below.
}
\item{sex}{Code for distinguishing sexes. 1 is for male, 2 is for female.}
\item{age}{Starting age of an age group. In \code{MLTlookup} these are 0, 1, 5, 10, ... 130. 
           The \code{MLT1Ylookup} table contains 1-year ages ranging from 0 to 130.}
\item{e0}{Level of life expectancy, starting at 20 and going by steps of 2.5 up to 115.}
\item{mx}{Mortality rates.}
\item{lx, Lx, sx}{Other life table columns.}
}
}
\source{
An updated version of these datasets were provided by Sara Hertog, United Nations Population Division, in October 2021 (package version >= 2.6-0).
     For previous version of the tables, install MortCast 2.5-0: `devtools::install_github("PPgp/MortCast@v2.5-0")`
}
\usage{
data(MLTlookup)
data(MLT1Ylookup)
}
\description{
Lookup tables containing values for various model life tables, including 
Coale-Demeny and UN life tables.
}
\examples{
data(MLTlookup)
str(MLTlookup)
# CD West life table for male at e0 of 80
subset(MLTlookup, type == "CD_West" & sex == 1 & e0 == 80)

}
\references{
Coale, A., P. Demeny, and B. Vaughn. 1983. Regional model life tables and stable 
populations. 2nd ed. New York: Academic Press.

\url{https://www.un.org/development/desa/pd/data/extended-model-life-tables}
}
\seealso{
\code{\link{mlt}}
}
\keyword{datasets}
