% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-premodern.R
\name{coo_truss}
\alias{coo_truss}
\title{Truss measurement}
\usage{
coo_truss(x)
}
\arguments{
\item{x}{a shape or an Ldk object}
}
\value{
a named numeric or matrix
}
\description{
A method to calculate on shapes or on \link{Coo} truss measurements,
that is all pairwise combinations of euclidean distances
}
\note{
Mainly implemented for historical/didactical reasons.
}
\examples{
# example on a single shape
cat <- coo_sample(shapes[4], 6)
coo_truss(cat)

# example on wings dataset
tx <- coo_truss(wings)
dim(tx)
# we normalize and plot an heatmap
txn <- apply(tx$coe, 2, .normalize)
# heatmap(txn)

txp <- PCA(tx, scale. = TRUE, center=TRUE, fac=wings$fac)
plot(txp, 1)
}
\seealso{
Other premodern: 
\code{\link{measure}()}
}
\concept{premodern}
