% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-ldk-procrustes.R
\name{pProcrustes}
\alias{pProcrustes}
\title{Partial Procrustes alignment between two shapes}
\usage{
pProcrustes(coo1, coo2)
}
\arguments{
\item{coo1}{Configuration matrix to be superimposed onto the centered preshape of coo2.}

\item{coo2}{Reference configuration matrix.}
}
\value{
a list with components
\itemize{
\item \code{coo1} superimposed centered preshape of coo1 onto the centered preshape of coo2
\item \code{coo2} centered preshape of coo2
\item \code{rotation} rotation matrix
\item \code{DP} partial Procrustes distance between coo1 and coo2
\item \code{rho} trigonometric Procrustes distance.
}
}
\description{
Directly borrowed from Claude (2008), and called \code{pPsup} there.
}
\references{
Claude, J. (2008). Morphometrics with R. Analysis (p. 316). Springer.
}
\seealso{
Other procrustes functions: \code{\link{fProcrustes}},
  \code{\link{fgProcrustes}}, \code{\link{fgsProcrustes}}
}
