% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-Out.R
\name{symmetry}
\alias{symmetry}
\title{Calcuates symmetry indices on OutCoe objects}
\usage{
symmetry(OutCoe)
}
\arguments{
\item{OutCoe}{[efourier] objects}
}
\value{
a matrix with 4 colums described above.
}
\description{
For \link{OutCoe} objects obtained with \link{efourier}, calculates several
indices on the matrix of coefficients: \code{AD}, the sum of absolute values of
harmonic coefficients A and D; \code{BC} same thing for B and C; \code{amp} the
sum of the absolute value of all harmonic coefficients and \code{sym} which is the ratio
of \code{AD} over \code{amp}. See references below for more details.
}
\examples{
data(bot)
bot.f <- efourier(bot, 12)
res <- symmetry(bot.f)
hist(res[, 'sym'])
}
\references{
Below: the first mention, and two applications.
\itemize{
#' \item Iwata, H., Niikura, S., Matsuura, S., Takano, Y., & Ukai, Y. (1998).
Evaluation of variation of root shape of Japanese radish (Raphanus sativus L.)
based on image analysis using elliptic Fourier descriptors. Euphytica, 102, 143-149.
\item Iwata, H., Nesumi, H., Ninomiya, S., Takano, Y., & Ukai, Y. (2002).
The Evaluation of Genotype x Environment Interactions of Citrus Leaf Morphology
Using Image Analysis and Elliptic Fourier Descriptors. Breeding Science, 52(2),
89-94. doi:10.1270/jsbbs.52.89
\item Yoshioka, Y., Iwata, H., Ohsawa, R., & Ninomiya, S. (2004).
Analysis of petal shape variation of Primula sieboldii by elliptic fourier descriptors
and principal component analysis. Annals of Botany, 94(5), 657-64. doi:10.1093/aob/mch190
}
}
\seealso{
\link{rm_asym} and \link{rm_sym}.
}

