% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-utilities.R
\name{add_ldk}
\alias{add_ldk}
\title{Adds new landmarks on Out and Opn objects}
\usage{
add_ldk(Coo, nb.ldk)
}
\arguments{
\item{Coo}{an Out or Opn object}

\item{nb.ldk}{the number of landmarks to add on every shape}
}
\value{
an Out or an Opn object with some landmarks defined
}
\description{
Helps to add new landmarks on a \code{Coo} object on top of existing ones.
The number of landmarks must be specified and rows indices that
correspond to the nearest points clicked on every outlines are
stored in the \code{$ldk} slot of the \code{Coo} object.
}
\details{
Note that if no landmarks are already defined,
then this function is equivalent to \link{def_ldk}.
}
\examples{
\dontrun{
data(hearts)
hearts <- slice(hearts, 1:5) # to make it shorter to try
# click on 3 points, 5 times.
# Don't forget to save the object returned by def_ldk...
hearts2 <- add_ldk(hearts, 3)
stack(hearts2)
hearts2$ldk
}
}
\seealso{
Other ldk/slidings methods: \code{\link{def_ldk}},
  \code{\link{def_slidings}}, \code{\link{get_ldk}},
  \code{\link{get_slidings}}, \code{\link{slidings_scheme}}
}

