% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{motbf_type}
\alias{motbf_type}
\title{Type of MoTBF}
\usage{
motbf_type(bn)
}
\arguments{
\item{bn}{A list of lists obtained from the function \link{MoTBFs_Learning}.}
}
\value{
A character string, specifying the subclass of MoTBF, i.e., either MTE or MOP.
}
\description{
This function checks whether the density functions of a MoTBF-BN are of type MTE or MOP.
}
\examples{

## Dataset
  data("ecoli", package = "MoTBFs")
  data <- ecoli[,-c(1,9)]

## Get directed acyclic graph
  dag <- LearningHC(data)
  
## Learn bayesian network
  bn <- MoTBFs_Learning(dag, data = data, numIntervals = 4, POTENTIAL_TYPE = "MTE") 
  
## Get MoTBF sub-class
  motbf_type(bn)
}
