% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Functions.R
\name{MoE_plotCrit}
\alias{MoE_plotCrit}
\title{Model Selection Criteria Plot for MoEClust Mixture Models}
\usage{
MoE_plotCrit(res,
             criterion = c("bic", "icl", "aic"),
             ...)
}
\arguments{
\item{res}{An object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}}, or an object of class \code{"MoECompare"} generated by \code{\link{MoE_compare}}. Models with a noise component are facilitated here too.}

\item{criterion}{The criterion to be plotted. Defaults to \code{"bic"}.}

\item{...}{Catches other arguments, or additional arguments to be passed to \code{\link[mclust]{plot.mclustBIC}} (or equivalent functions for the other \code{criterion} arguments).}
}
\value{
A plot of the values of the chosen \code{criterion}. The values themselves can also be returned invisibly.
}
\description{
Plots the BIC, ICL, or AIC values of a fitted \code{MoEClust} object.
}
\note{
\code{\link{plot.MoEClust}} is a wrapper to \code{\link{MoE_plotCrit}} which accepts the default arguments, and also produces other types of plots.
}
\examples{
\dontrun{
data(ais)
res   <- MoE_clust(ais[,3:7], expert= ~ sex, network.data=ais)
(crit <- MoE_plotCrit(res))}
}
\seealso{
\code{\link{MoE_clust}}, \code{\link{plot.MoEClust}}, \code{\link[mclust]{plot.mclustBIC}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{plotting}
