% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tM.R
\name{tM}
\alias{tM}
\title{\emph{t} Mixture (\emph{t}M)}
\usage{
tM(
  X,
  G,
  max_iter = 20,
  epsilon = 0.01,
  init_method = c("kmedoids", "kmeans", "hierarchical", "manual", "soft", "hard"),
  equal_prop = TRUE,
  unit_var = FALSE,
  df0 = rep(10, G),
  outlier_cutoff = 0.95,
  show_progress = TRUE,
  manual_clusters = NULL
)
}
\arguments{
\item{X}{A vector of \emph{n} observations.}

\item{G}{The number of clusters.}

\item{max_iter}{(optional) A numeric value giving the maximum number of
iterations each EM algorithm is allowed to use; 20 by default.}

\item{epsilon}{(optional) A number specifying the epsilon value for the
Aitken-based stopping criterion used in the EM algorithm: 0.01 by default.}

\item{init_method}{(optional) A string specifying the method to initialize
the EM algorithm. "kmedoids" clustering is used by default. Alternative
methods include "kmeans", "hierarchical", "manual", "soft", "hard". When
"manual" is chosen, a vector \code{manual_clusters} of length \eqn{n} must
be specified.}

\item{equal_prop}{(optional) A logical value indicating whether mixing
proportions should be equal at initialization of the EM algorithm; FALSE by
default.}

\item{unit_var}{(optional) A logical value indicating whether variance should
be initialized as 1; FALSE by default.}

\item{df0}{(optional) Starting values of the degrees of freedom; 10 for all
clusters by default.}

\item{outlier_cutoff}{(optional) A percentile for outlier detection; 0.95 by default.}

\item{show_progress}{(optional) A logical value indicating whether the
fitting progress should be displayed; TRUE by default.}

\item{manual_clusters}{A vector of length \eqn{n} that specifies the initial
cluster memberships of the user when \code{init_method} is set to "manual".
Both numeric and character vectors are acceptable. This argument is NULL by
default, so that it is ignored whenever other given initialization methods
are chosen.}
}
\value{
An object of class \code{MixtureMissing} with:
  \item{pi}{Mixing proportions.}
  \item{mu}{Component means.}
  \item{sigma}{Component variances.}
  \item{df}{Component degrees of freedom.}
  \item{z_tilde}{An \eqn{n} by \eqn{G} matrix where each row indicates the expected
    probabilities that the corresponding observation belongs to each cluster.}
  \item{clusters}{A numeric vector of length \eqn{n} indicating cluster
    memberships determined by the model.}
  \item{outliers}{A logical vector of length \eqn{n} indicating observations that are ouliers.}
  \item{data}{The original data set if it is complete; otherwise, this is
    the data set with missing values imputed by appropriate expectations.}
  \item{complete}{A logical vector of length \eqn{n} indicating which observation(s)
    have no missing values.}
  \item{npar}{The breakdown of the number of parameters to estimate.}
  \item{max_iter}{Maximum number of iterations allowed in the EM algorithm.}
  \item{iter_stop}{The actual number of iterations needed when fitting the
    data set.}
  \item{final_lik}{The final value of likelihood.}
  \item{final_loglik}{The final value of log-likelihood.}
  \item{lik}{All the values of likelihood.}
  \item{loglik}{All the values of log-likelihood.}
  \item{AIC}{Akaike information criterion.}
  \item{BIC}{Bayesian information criterion.}
  \item{KIC}{Kullback information criterion.}
  \item{KICc}{Corrected Kullback information criterion.}
  \item{AIC3}{Modified AIC.}
  \item{CAIC}{Bozdogan's consistent AIC.}
  \item{AICc}{Small-sample version of AIC.}
  \item{ent}{Entropy}
  \item{ICL}{Integrated Completed Likelihood criterion.}
  \item{AWE}{Approximate weight of evidence.}
  \item{CLC}{Classification likelihood criterion.}
  \item{init_method}{The initialization method used in model fitting.}
}
\description{
Carries out model-based clustering using a \emph{t} mixture (\emph{t}M) for
complete univariate data set.
}
\examples{
set.seed(1234)

mod <- tM(iris$Sepal.Length, G = 3, init_method = 'kmedoids', max_iter = 30)

plot(mod)
summary(mod)

}
\references{
Peel,  D.  and  McLachlan,  G.  J.  (2000).   Robust  mixture  modelling
  using the \emph{t}  distribution. \emph{Statistics and computing, 10}(4):339-348.
}
