% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixreg.R
\name{mixregT}
\alias{mixregT}
\title{Robust Mixture Regression with T-distribution}
\usage{
mixregT(x, y, C = 2, maxdf = 30, nstart = 20, tol = 1e-05)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and p is the number of explanatory variables.
The intercept term will automatically be added to the data.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{maxdf}{maximum degrees of freedom for the t-distribution. Default is 30.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{threshold value (stopping criteria) for the EM algorithm. Default is 1e-05.}
}
\value{
A list containing the following elements:
\item{pi}{C-dimensional vector of estimated mixing proportions.}
\item{beta}{C by (p + 1) matrix of estimated regression coefficients.}
\item{sigma}{C-dimensional vector of estimated standard deviations.}
\item{lik}{final likelihood.}
\item{df}{estimated degrees of freedom of the t-distribution.}
\item{run}{total number of iterations after convergence.}
}
\description{
`mixregT' provides a robust estimation for a mixture of linear regression models
by assuming that the error terms follow the t-distribution (Yao et al., 2014). The degrees of freedom
is adaptively estimated.
}
\examples{
data(tone)
y = tone$tuned
x = tone$stretchratio
k = 160
x[151:k] = 0
y[151:k] = 5
\donttest{est_t = mixregT(x, y, 2, nstart = 20, tol = 0.1)}
}
\references{
Yao, W., Wei, Y., and Yu, C. (2014). Robust mixture regression using the t-distribution.
Computational Statistics & Data Analysis, 71, 116-127.
}
\seealso{
\code{\link{mixregLap}} for robust estimation with Laplace distribution.
}
