% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/IClusterModel.R
\docType{class}
\name{IClusterModelBase}
\alias{IClusterModelBase}
\alias{IClusterModelBase-class}
\title{Interface base Class [\code{\linkS4class{IClusterModelBase}}] for Cluster models.}
\description{
This class encapsulate the common parameters of all the Cluster models.
}
\details{
A Cluster model is a model of the form
\deqn{
  f({x}|\boldsymbol{\theta})
    \sum_{k=1}^K p_k h({x};\boldsymbol{\lambda}_k,\boldsymbol{\alpha})
   \quad {x} \in J.
}
where h can be either a pdf, a discrete probability, (homogeneous case)
or a product of arbitrary pdf and discrete probabilities (heterogeneous case).
}
\section{Slots}{

\describe{
\item{\code{nbSample}}{Integer with the number of samples of the model.}

\item{\code{nbCluster}}{Integer with the number of cluster of the model.}

\item{\code{pk}}{Vector of size K with the proportions of each mixture.}

\item{\code{tik}}{Matrix of size \eqn{n \times K} with the posterior probability of
the ith individual to belong to kth cluster.}

\item{\code{lnFi}}{Vector of size n with the log-likelihood of the ith individuals.}

\item{\code{zi}}{Vector of integer of size n  with the attributed class label of the individuals.}

\item{\code{lnLikelihood}}{Real given the ln-liklihood of the Cluster model.}

\item{\code{criterion}}{Real given the value of the AIC, BIC or ICL criterion.}

\item{\code{nbFreeParameter}}{Integer given the number of free parameters of the model.}

\item{\code{strategy}}{the instance of the [\code{\linkS4class{ClusterStrategy}}] used in the
estimation process of the mixture. Default is clusterStrategy().}
}}
\examples{
getSlots("IClusterModelBase")
}
\author{
Serge Iovleff
}

