% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{distri_1_taxa}
\alias{distri_1_taxa}
\title{Distribution of sequences across a factor for one taxon}
\usage{
distri_1_taxa(physeq, fact, taxa_name, digits = 2)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor in \code{physeq@sam_data} used to plot
different lines}

\item{taxa_name}{(required): the name of the taxa}

\item{digits}{(default = 2) integer indicating the number of decimal places
to be used (see \code{?round} for more information)}
}
\value{
a dataframe with levels as rows and information as column :
\itemize{
\item the number of sequences of the taxa (nb_seq)
\item the number of samples of the taxa (nb_samp)
\item the mean (mean_nb_seq) and standard deviation (sd_nb_seq) of the \emph{nb_seq}
\item the mean (mean_nb_seq_when_present) \emph{nb_seq} excluding samples with zero
\item the total number of samples (nb_total_samp)
\item the proportion of samples with the taxa
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
distri_1_taxa(data_fungi, "Height", "ASV2")
distri_1_taxa(data_fungi, "Time", "ASV81", digits = 1)
}
\author{
Adrien Taudière
}
