% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{umap_pq}
\alias{umap_pq}
\title{Computes a manifold approximation and projection (UMAP) for
phyloseq object}
\usage{
umap_pq(physeq, pkg = "umap", ...)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{pkg}{Which R packages to use, either "umap" or "uwot".}

\item{...}{Additional arguments passed on to \code{\link[umap:umap]{umap::umap()}} or
\code{\link[uwot:umap2]{uwot::umap2()}} function.
For example \code{n_neighbors} set the number of nearest neighbors (Default 15).
See \code{\link[umap:umap.defaults]{umap::umap.defaults()}} or \code{\link[uwot:umap2]{uwot::umap2()}} for the list of
parameters and default values.}
}
\value{
A dataframe with samples informations and the x_umap and y_umap position
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


https://journals.asm.org/doi/full/10.1128/msystems.00691-21
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{umap::umap()} if you
use this function.
}
\examples{
library("umap")
df_umap <- umap_pq(data_fungi_mini)
ggplot(df_umap, aes(x = x_umap, y = y_umap, col = Height)) +
  geom_point(size = 2)

# library(patchwork)
# physeq <- data_fungi_mini
# res_tsne <- tsne_pq(data_fungi_mini)
# df_umap_tsne <- df_umap
# df_umap_tsne$x_tsne <- res_tsne$Y[, 1]
# df_umap_tsne$y_tsne <- res_tsne$Y[, 2]
# ((ggplot(df_umap, aes(x = x_umap, y = y_umap, col = Height)) +
#  geom_point(size = 2) +
#  ggtitle("UMAP")) + (plot_ordination(physeq,
#  ordination =
#    ordinate(physeq, method = "PCoA", distance = "bray"), color = "Height"
# )) +
#  ggtitle("PCoA")) /
#  ((ggplot(df_umap_tsne, aes(x = x_tsne, y = y_tsne, col = Height)) +
#    geom_point(size = 2) +
#    ggtitle("tsne")) +
#    (plot_ordination(physeq,
#      ordination = ordinate(physeq, method = "NMDS", distance = "bray"),
#      color = "Height"
#    ) +
#      ggtitle("NMDS"))) +
#  patchwork::plot_layout(guides = "collect")

# df_uwot <- umap_pq(data_fungi_mini, pkg = "uwot")

#   (ggplot(df_umap, aes(x = x_umap, y = y_umap, col = Height)) +
#     geom_point(size = 2) +
#    ggtitle("umap::umap")) /
#     (ggplot(df_uwot, aes(x = x_umap, y = y_umap, col = Height)) +
#       geom_point(size = 2) +
#       ggtitle("uwot::umap2"))

}
\seealso{
\code{\link[umap:umap]{umap::umap()}}, \code{\link[=tsne_pq]{tsne_pq()}}, \code{\link[phyloseq:plot_ordination]{phyloseq::plot_ordination()}}
}
\author{
Adrien Taudière
}
