% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humans_SIR.R
\name{get_config_humans_SIR}
\alias{get_config_humans_SIR}
\title{Get parameters for SIR human model}
\usage{
get_config_humans_SIR(path)
}
\arguments{
\item{path}{a file path to a JSON file}
}
\value{
a named \link{list}
}
\description{
The JSON config file should have 8 entries:
\itemize{
\item stochastic: a boolean value
\item theta: matrix (row major)
\item wf: vector
\item H: vector
\item SIR: matrix (row major)
\item b: scalar
\item c: scalar
\item gamma: scalar
}

For interpretation of the entries, please read \link{setup_humans_SIR}.
}
\examples{
# to see an example of proper JSON input, run the following
library(jsonlite)
n <- 6 # number of human population strata
p <- 5 # number of patches
theta <- matrix(rexp(n*p), nrow = n, ncol = p)
theta <- theta / rowSums(theta)
H <- rep(10, n)
SIR <- matrix(0, nrow = n, ncol = 3)
SIR[, 1] <- H
par <- list(
 "stochastic" = FALSE,
 "theta" = theta,
 "wf" = rep(1, n),
 "H" = H,
 "SIR" = SIR,
 "b" = 0.55,
 "c" = 0.15,
 "gamma" = 1/7
)
toJSON(par, pretty = TRUE)
}
