% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRKAT_Continuous.R
\name{MiRKAT_continuous}
\alias{MiRKAT_continuous}
\title{Microbiome Regression-based Analysis Test for a continuous outcome variable}
\usage{
MiRKAT_continuous(
  y,
  X = NULL,
  Ks,
  method = "davies",
  nperm = 999,
  returnKRV = FALSE,
  returnR2 = FALSE
)
}
\arguments{
\item{y}{A numeric vector of the continuous outcome variable}

\item{X}{A numeric matrix or data frame containing additional covariates (default = NULL). If NULL, an intercept only model is used.}

\item{Ks}{A list of n by n kernel matrices (or a single n by n kernel matrix), where n is the sample size. It can be constructed 
from microbiome data through distance metric or other approaches, such as linear kernels or Gaussian kernels.}

\item{method}{A method to compute the kernel specific p-value (Default= "davies"). "davies" represents an exact method that computes
the p-value by inverting the characteristic function of the mixture chisq. We adopt an exact variance component tests because most 
of the studies concerning microbiome compositions have modest sample size. "moment" represents an approximation method that matches
the first two moments. "permutation" represents a permutation approach for p-value calculation.}

\item{nperm}{the number of permutations if method = "permutation" or when multiple kernels are considered. If method = "davies" or 
"moment", nperm is ignored. Defaults to 999.}

\item{returnKRV}{A logical indicating whether to return the KRV statistic. Defaults to FALSE.}

\item{returnR2}{A logical indicating whether to return the R-squared coefficient. Defaults to FALSE.}
}
\value{
If only one candidate kernel matrix is considered, returns a list containing the p-value for the candidate kernel matrix. 
If more than one candidate kernel matrix is considered, returns a list of two elements: the individual p-values for
each candidate kernel matrix, and the omnibus p-value
    \item{indivP}{p-value for each candidate kernel matrix}
    \item{omnibus_p}{omnibus p-value considering multiple candidate kernel matrices}
    \item{KRV}{A vector of kernel RV statistics (a measure of effect size), one for each candidate kernel matrix. Only returned if returnKRV = TRUE}
    \item{R2}{A vector of R-squared statistics, one for each candidate kernel matrix. Only returned if returnR2 = TRUE}
}
\description{
Inner function for MiRKAT; computes MiRKAT for continuous outcomes. Called by MiRKAT if out_type="C"
}
\details{
This function is called by the exported function "MiRKAT" when the argument of MiRKAT, out_type, is set equal to "C". 

Each argument of MiRKAT_continuous is given the value of the corresponding argument given by the user to MiRKAT.

Function not exported
}
\references{
Zhao, N., Chen, J.,Carroll, I. M., Ringel-Kulka, T., Epstein, M.P., Zhou, H., Zhou, J. J., Ringel, Y., Li, H. and Wu, M.C. (2015)).
Microbiome Regression-based Kernel Association Test (MiRKAT). American Journal of Human Genetics, 96(5):797-807

Chen, J., Chen, W., Zhao, N., Wu, M~C.and Schaid, D~J. (2016) Small Sample Kernel Association Tests for Human Genetic and 
Microbiome Association Studies. 40: 5-19. doi: 10.1002/gepi.21934

Davies R.B. (1980) Algorithm AS 155: The Distribution of a Linear Combination of chi-2 Random Variables, Journal of the Royal
Statistical Society. Series C , 29, 323-333.

Satterthwaite, F. (1946). An approximate distribution of estimates of variance components. Biom. Bull. 2, 110-114.

Lee S, Emond MJ, Bamshad MJ, Barnes KC, Rieder MJ, Nickerson DA; NHLBI GO Exome Sequencing Project-ESP Lung Project Team, 
Christiani DC, Wurfel MM, Lin X. (2012) Optimal unified approach for rare variant association testing with application to small
sample case-control whole-exome sequencing studies. American Journal of Human Genetics, 91, 224-237.

Zhou, J. J. and Zhou, H.(2015) Powerful Exact Variance Component Tests for the Small Sample Next Generation Sequencing Studies 
(eVCTest), in submission.
}
\author{
Ni Zhao
}
