% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiInflCount.R
\name{MiInflCount}
\alias{MiInflCount}
\title{Mean microarray probes' feature importance from binary classification}
\usage{
MiInflCount(importance.list)
}
\arguments{
\item{importance.list}{a list of data frames, containing the result of binary classification:
probe IDs in first column and probe's feature importance (relative influence) in the second column
in the order from most important to the least important for classification.
Such list is the \code{\link{MiBiClassGBODT}} output (\code{Importance}).}
}
\value{
a list of 2
\cr
\code{data.mean} - data frame of probe names (in alphabetical order), their mean feature importance
and standard deviation.
\cr
\code{data.importance} - data frame of probe IDs (in alphabetical order) and their
original feature importance values gained in all cross-validation models.
}
\description{
Counts mean of probes' feature importance for multiple models of binary classification built
on microarray gene/transcript expression data
}
\details{
This function takes the result of binary classification performed with cross-validation
and counts mean of each probe's feature importance (relative influence) gained in all fitted models.
}
\examples{

# get gene expression and specimen data
data("IMexpression");data("IMspecimen")
# sample expression matrix and specimen data for binary classification,
# only "NORM" and "EBV" specimens are left
SampleMatrix<-MiDataSample(IMexpression, IMspecimen$diagnosis,"norm", "ebv")
SampleSpecimen<-MiSpecimenSample(IMspecimen$diagnosis, "norm", "ebv")
#Fitting, low tuning for faster running
ClassRes<-MiBiClassGBODT(SampleMatrix, SampleSpecimen, n.crossval = 3,
                        ntrees = 10, shrinkage = 1, intdepth = 2)
# List of influence data frames for all 3 models build using cross-validation
# is the 2nd element of BiClassGBODT results
Importances<-MiInflCount(ClassRes[[2]])
Importances[[1]][1:10,] # mean and sd. 0s are for low feature importance
Importances[[2]][1:10,] # original values for n.crossval = 3 models

}
\seealso{
\code{\link{MiBiClassGBODT}}
}
\author{
Elena N. Filatova
}
