% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{Mean-squared error}
\usage{
mse(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{weighted_mean}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted mean-squared error of prediction. Equals mean unit normal deviance.
}
\examples{
mse(1:10, (1:10)^2)
mse(1:10, (1:10)^2, w = rep(1, 10))
mse(1:10, (1:10)^2, w = 1:10)

}
\seealso{
\code{\link{rmse}, \link{deviance_normal}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
