% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmm-class.R
\docType{class}
\name{cvmm-class}
\alias{cvmm-class}
\alias{cvmm}
\alias{show,cvmm-method}
\alias{summary,cvmm-method}
\alias{plot,cvmm,ANY-method}
\alias{cvmm-method}
\title{The cvmm Class.}
\usage{
\S4method{show}{cvmm}(object)

\S4method{summary}{cvmm}(object, which = 1)

\S4method{plot}{cvmm,ANY}(x, y, which = 1, ...)
}
\arguments{
\item{object}{A CVMetSpecificCoxPh class object}

\item{which}{This specify which metabolite for which estimated HR information need to be visualized. By default results of the first metabolite is used.}

\item{x}{A CVMetSpecificCoxPh class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MetabolicSurv]{CVMetSpecificCoxPh}}.
}
\details{
plot signature(x = "cvmm"): Plots for \code{\link[MetabolicSurv]{CVMetSpecificCoxPh}} class analysis results.

Any parameters of \code{\link[graphics]{plot.default}} may be passed on to this particular plot method.
}
\section{Slots}{

\describe{
\item{\code{HRTrain}}{A 3-way array, The first dimension is the number of metabolites, the second dimension is the HR statistics for the low risk group in the train dataset (HR,1/HR LCI, UCI) while the third dimension is the number of cross validation performed.}

\item{\code{HRTest}}{A 3-way array, The first dimension is the number of metabolites, the second dimension is the HR statistics for the low risk group in the test dataset (HR,1/HR LCI, UCI) while the third dimension is the number of cross validation performed.}

\item{\code{train}}{The selected subjects for each CV in the train dataset}

\item{\code{test}}{The selected subjects for each CV in the test dataset}

\item{\code{n.mets}}{The number of metabolite used in the analysis}

\item{\code{Ncv}}{The number of cross validation performed}

\item{\code{Rdata}}{The Metabolite data matrix that was used for the analysis either same as Mdata or a reduced version}
}}

\examples{
\donttest{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## USING THE FUNCTION
Result = CVMetSpecificCoxPh(Fold=3,Survival=Data$Survival,
Mdata=t(Data$Mdata),Censor= Data$Censor,Reduce=TRUE,
Select=150,Prognostic=Data$Prognostic,Quantile = 0.5,Ncv=3)

## GET THE CLASS OF THE OBJECT
class(Result)     # An "cvmm" Class

##  METHOD THAT CAN BE USED FOR THIS CLASS
show(Result)
summary(Result)
plot(Result)
}
}
\seealso{
\code{\link[MetabolicSurv]{CVMetSpecificCoxPh}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
