% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggForestPlot.R
\name{ggForestPlot}
\alias{ggForestPlot}
\title{Compare effect sizes of a gene across all datasets in meta-analysis}
\usage{
ggForestPlot(metaObject, genes, confLevel = 0.95, facetCols = NULL,
  facetScales = "free_x", boxScales = c(6, 16))
}
\arguments{
\item{metaObject}{a filtered metaObject, i.e. it needs to include a \code{filterObject} generated by the function \code{filterGenes()}}

\item{genes}{character vector containing the genes for which the forest plot should be generated}

\item{confLevel}{confidence level}

\item{facetCols}{integer that specifies how many columns are going to be used for the plot}

\item{facetScales}{same as ggplot's facet_wrap: should Scales be fixed ("fixed", the default), free ("free"), or free in one dimension ("free_x", "free_y")}

\item{boxScales}{a numeric vector of length 2 providing scaling factors for the plot. Specifies minimum and maximum size.}
}
\value{
ggplot2 Plot comparing effect sizes of a gene across datasets
}
\description{
A forest plot can be used to compare the expression values of a gene across different datasets. 
The area of the blue boxes is proportional to the number of samples in the study and black lines indicate the standard error of the effect sizes for each study (by default the 95\% confidence interval). 
The summary effect size for all studies is indicated as an orange diamond below and the width of the diamond indicates the summary standard error.
}
\examples{
# compare effect sizes of the Gene1 for all discovery datasets in tinyMetaObject 
ggForestPlot(tinyMetaObject, genes="Gene1")
}
\seealso{
\code{\link{filterGenes}},  \code{\link{runMetaAnalysis}},  \code{\link{violinPlot}}
}
\author{
Winston A. Haynes, Jiaying Toh, Michele Donato
}
\keyword{graphs}
\keyword{hplot}
