% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_search.R
\name{searchMZ}
\alias{searchMZ}
\title{Find matches for m/z value in given database}
\usage{
searchMZ(
  mzs,
  ionmodes,
  outfolder,
  base.dbname,
  ppm,
  ext.dbname = "extended",
  append = FALSE
)
}
\arguments{
\item{mzs}{Vector of m/z values}

\item{ionmodes}{Vector of pos/negative mode for each m/z value}

\item{outfolder}{Which folder are your databases stored in?}

\item{base.dbname}{Which base database do you want to retrieve info from? (without .db suffix)}

\item{ppm}{Parts per million accepted error range}

\item{ext.dbname}{Name of extended database (without .db suffix), Default: 'extended'}

\item{append}{Use this when searching muiltiple base databases, so only one result table is created, Default: FALSE}
}
\value{
Data table with match results
}
\description{
This function takes user m/z, ppm error, base database and the extended database to return hits of interest.
}
\examples{
 \dontrun{myFolder = tempdir()}
 \dontrun{buildBaseDB(outfolder = myFolder, "lmdb", test = TRUE)}
 \dontrun{file.remove(file.path(myFolder, "extended.db"))}
 \dontrun{data(adducts)}
 \dontrun{data(adduct_rules)}
 \dontrun{buildExtDB(outfolder = myFolder, base.dbname = "lmdb",
 silent=FALSE, adduct_table = adducts, adduct_rules = adduct_rules)}
 \dontrun{searchMZ(c("104.3519421"), "positive", outfolder = myFolder, "lmdb", ppm = 3)}
}
\seealso{
\code{\link[RSQLite]{SQLite}}
 \code{\link[data.table]{rbindlist}}
 \code{\link[DBI]{dbExecute}},\code{\link[DBI]{dbGetQuery}},\code{\link[DBI]{dbDisconnect}}
 \code{\link[gsubfn]{fn}}
}
