% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_parsers.R
\name{build.MACONDA}
\alias{build.MACONDA}
\title{Build MACONDA}
\usage{
build.MACONDA(outfolder, testMode = FALSE, conn, apikey)
}
\arguments{
\item{outfolder}{Which folder to save temp files to?}

\item{testMode}{run in test mode? Only parses first ten compounds}

\item{conn}{Connection to extended database (MaConDa writes directly to there due to anomalous adducts)}

\item{apikey}{ChemSpider API key}
}
\value{
data table with parsed database
}
\description{
Parses MACONDA, returns data table with columns compoundname, description, charge, formula and structure (in SMILES)
}
\examples{
\dontrun{build.MACONDA(outfolder=tempdir(), testMode=TRUE)}
}
\seealso{
\code{\link[stringr]{str_match}}
 \code{\link[utils]{download.file}},\code{\link[utils]{unzip}}
 \code{\link[data.table]{fread}}
 \code{\link[pbapply]{pbapply}}
 \code{\link[RSQLite]{SQLite}}
 \code{\link[DBI]{dbDisconnect}}
 \code{\link[gsubfn]{fn}}
}
