\name{print_mesh_obs}
\alias{print_mesh_obs}
\title{Print information for a list of mesh objects}
\description{Print the information stored in a list of mesh objects. This includes their respective number of vertices and triangles as well as their volume and centroid.}
\usage{
print_mesh_obs(x)
}
\arguments{
  \item{x}{\code{list} of mesh objects with a structure as generated by \code{\link[MeshAgreement]{read_mesh_obs}}.}
}
\details{Use \code{\link[MeshAgreement]{print_mesh_one}} for printing information for a single mesh object. Use \code{\link[MeshAgreement]{print_mesh}} for printing information for a list of observer/mesh objects.}
\value{Text output on the console.}
\seealso{
\code{\link[MeshAgreement]{read_mesh_obs}},
\code{\link[MeshAgreement]{print_mesh_one}},
\code{\link[MeshAgreement]{print_mesh}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
Obs01  <- heartL[["Obs01"]]
print_mesh_obs(Obs01)
}
