fluidPage(
    fluidRow(
        box(title="Methods",
            # height = "600px",
            # width = 6,
            # status = NULL, 
            # closable = FALSE,
            # maximizable = FALSE, 
            # collapsible = TRUE,
            # overflow=TRUE,
            h3("Geometric agreement measures"),
            tags$ul(tags$li("Distance-based agreement measures"),
                    tags$ul(tags$li("DCOM: Distance between centers of mass"),
                            tags$li("ASD: Average symmetric surface distance"),
                            tags$li("RMSD: Root mean squared symmetric surface distance"),
                            tags$li("HD_max: Hausdorff distance - worst case, maximum of both directed Hausdorff distances"),
                            tags$li("HD_avg: Hausdorff distance - average, mean of both directed Hausdorff distances")),
                    tags$li("Volume-overlap based measures"),
                    tags$ul(tags$li("JSC: Jaccard similarity coefficient"),
                    tags$li("DSC: Dice similarity coefficient"))),
                    p("The calculated agreement measures are defined and discussed in these publications:"),
            tags$ul(# tags$li("Supplement to:",
                    #         tags$a(href="https://doi.org/10.1186/s13014-021-01965-5",
                    #                "Stockinger M, Karle H, Rennau H, Sebb S, Wolf U, Remmele J, Bührdel S, Bartkowiak D, Blettner M, Schmidberger H, Wollschläger D. Heart atlas for retrospective cardiac dosimetry: a multi-institutional study on interobserver contouring variations and their dosimetric impact. Radiat Oncol 2021; 16: 241.")),
                    # tags$li("Babalola et al. An evaluation of four automatic methods of segmenting the subcortical structures in the brain. NeuroImage 2009; 47: 1435-1447."),
                    tags$li("Fotina et al. Critical discussion of evaluation parameters for inter-observer variability in target definition for radiation therapy. Strahlenther Onkol 2012; 188: 160-167."),
                    tags$li("Hanna  et al. Geometrical Analysis of Radiotherapy Target Volume Delineation: a Systematic Review of Reported Comparison Methods. Clin Oncol 2010; 22, 515-525."),
                    tags$li("Heimann et al. Comparison and Evaluation of Methods for Liver Segmentation From CT Datasets. IEEE Trans Med Imaging 2009; 28: 1251-1265."),
                    tags$li("Sherer et al. Metrics to evaluate the performance of auto-segmentation for radiation treatment planning: A critical review. Radiother Oncol 2021; 160: 185-191.")),
            p("The geometric agreement is first calculated for all possible volume pairs, and then averaged over these pairs."),
            tags$ul(tags$li("Coefficient of variation - for aggregating pairwise similarity measures"),
                    tags$ul(tags$li("CV: SD(x) / Mean(x)"),
                            tags$li("CV_ln: sqrt(exp(var(log(x))) - 1) - assuming log-normal distribution")))
        ),
        box(# height = "600px",
            title="Project contributors",
            # width = 6,
            # status = NULL, 
            # closable = FALSE,
            # maximizable = FALSE, 
            # collapsible = TRUE,
            h3("People"),
            p(tags$a(href="https://www.unimedizin-mainz.de/",
                            "University Medical Center"),
                     "of the",
                     tags$a(href="https://www.uni-mainz.de/",
                            "Johannes Gutenberg-University Mainz")),
            tags$ul(tags$li(tags$a(href="https://www.unimedizin-mainz.de/imbei/",
                           "Institute of Medical Biostatistics, Epidemiology and Informatics (IMBEI)"),
                    tags$ul(tags$li(tags$a(href="https://www.unimedizin-mainz.de/imbei/epidemiologie/epidemiologische-methodik-und-strahlenforschung/wollschlaeger.html",
                                           "PD Dr. Daniel Wollschläger"), "<wollschlaeger@uni-mainz.de>")
                    )),
            tags$li(tags$a(href="https://www.unimedizin-mainz.de/radioonkologie-und-strahlentherapie/startseite/startseite.html", 
                           "Department of Radiation Oncology and Radiotherapy"),
                    tags$ul(tags$li(tags$a(href="https://www.unimedizin-mainz.de/radioonkologie-und-strahlentherapie/startseite/mitarbeiter/medizinphysik.html",
                                           "Heiko Karle"))))),
            h3("Software"),
            p("This web application is part of the R package",
              tags$a(href="https://github.com/dwoll/MeshAgreement", "MeshAgreement"),
                      "which itself is based on the following software:"),
              tags$ul(
              tags$li(icon("r-project", lib="font-awesome"),
                      tags$a(href="https://www.r-project.org/", "R"),
                      "packages:"),
              tags$ul(tags$li(      tags$a(href="https://CRAN.R-project.org/package=shiny",      "shiny"),
                              ", ", tags$a(href="https://CRAN.R-project.org/package=bs4Dash",    "bs4Dash"),
                              ", ", tags$a(href="https://CRAN.R-project.org/package=rgl",        "rgl"),
                              ", ", tags$a(href="https://CRAN.R-project.org/package=Rvcg",       "Rvcg"),
                              ", ", tags$a(href="https://CRAN.R-project.org/package=cgalMeshes", "cgalMeshes"))),
              tags$li(tags$a(href="https://www.cgal.org/", "CGAL"),
                      " - used as a backend for computational geometry calculations via R package",
                      tags$a(href="https://CRAN.R-project.org/package=RcppCGAL", "RcppCGAL")),
              tags$li(tags$a(href="http://www.vcglib.net/", "VCG Library"),
                      " - used as a backend for distance calculations via R package",
                      tags$a(href="https://CRAN.R-project.org/package=Rvcg", "Rvcg")),
              tags$li(tags$a(href="Export3D.cs", "ESAPI script"), "to export 3D mesh files in PLY format from Varian Eclipse."))
        )
    )
)
