% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2riterate.R
\name{applyFnToRanges}
\alias{applyFnToRanges}
\title{apply a function to all the genotypes for markers found in several specified ranges}
\usage{
applyFnToRanges(op          = function (markers, range, envir) {},
                ranges_arg  = NULL,
                indices_arg = NULL,
                fuzz_arg    = 0,
                envir       = ENV)
}
\arguments{
\item{op}{Is a function of three arguments.  It will be called repeatedly by
\code{applyFnToRanges} in a try/catch context.  The arguments are:
\describe{
\item{markers}{Marker data for each marker in \strong{geno}.  A marker is a data frame with the following 5 observations:
\describe{
\item{locus_link}{is the ordinal ranking of this marker among all loci}
\item{locus_link_fill}{is the position of corresponding marker genotype data in the
\emph{unified_genotype_table}}
\item{MarkerName}{is the text name of the marker}
\item{chromosome}{is the integer chromosome number}
\item{position}{is the integer base pair position of marker}
 }
}
\item{range}{An indicator of which range argument of \code{applyFnToRanges} these markers correspond to.}
\item{envir}{An 'environment' holding Mega2R data frames and state data.}
}}

\item{ranges_arg}{is a data frame that contains at least 4 observations: a name, a chromosome, a
start base pair position and an end base pair position.}

\item{indices_arg}{is a vector of 3 integers that specify the location of chromosome, start base
pair column and end base pair column of the ranges_arg data frame. An optional fourth integer
indicates the column containing the name of the ranges.}

\item{fuzz_arg}{is an integer vector of length one or two.  The first argument is used to reduce
the start base pair selected from each range and the second to increase the end base pair
position.  (If only one value is present, it is used for both changes.) Note: The values
can be positive or negative.}

\item{envir}{an 'environment' that contains all the data frames created from the SQLite database.}
}
\value{
None
}
\description{
First, for each range, determine the markers that fall between the start and end
base pair of the range.  Then, for each set of
 markers generate a matrix of the genotypes of those markers.  Finally, the \code{op} function is called for
 each range with the arguments: markers, range, and 'environment'.
}
\note{
If the \emph{ranges_arg} and \emph{indices_arg} are NULL or missing, then the default ranges that have been set by \code{setRanges}
 are used.  If \code{setRanges} has not been called, a default set of the ranges is used.
}
\examples{
  db = system.file("exdata", "seqsimm.db", package="Mega2R")
  ENV = read.Mega2DB(db)

  show = function(m, r, e) {
      print(r)
      print(m)
      print(head(getgenotypesraw(m, envir = e)))
  }

   # apply function "show" to all genotypes on chromosomes 1 for two base pair
   # ranges
   applyFnToRanges(show,
                   ranges_arg =
                   matrix(c(1, 2244000, 2245000,
                            1, 3762500, 3765000),
                           ncol = 3, nrow = 2, byrow = TRUE),
                   indices_arg = 1:3)

   # apply function "show" to all genotypes on chromosomes 1 for two base pair
   # ranges
   applyFnToRanges(show,
                   ranges_arg =
                   matrix(c(1, 2240000, 2245000, "range1",
                            1, 3760000, 3765000, "range2"),
                           ncol = 4, nrow = 2, byrow = TRUE),
                   indices_arg = 1:4)

}
