% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortMeasurementUse.R
\name{summariseCohortMeasurementUse}
\alias{summariseCohortMeasurementUse}
\title{Diagnostics of a codelist of measurement codes within a cohort}
\usage{
summariseCohortMeasurementUse(
  codes,
  cohort,
  timing = "during",
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  dateRange = as.Date(c(NA, NA)),
  checks = c("measurement_timings", "measurement_value_as_numeric",
    "measurement_value_as_concept")
)
}
\arguments{
\item{codes}{A codelist of measurement/observation codes for which to perform
diagnostics.}

\item{cohort}{A cohort in which to perform the diagnostics of the measurement
codes provided.}

\item{timing}{Three options: 1) "any" if the interest is on measurement
recorded any time, 2) "during", if interested in measurements while the
subject is in the cohort (or in observation if cohort = NULL), and 3)
"cohort_start_date" for measurements occurring at cohort start date (or at
"observation_period_start_date if cohort = NULL).}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{dateRange}{Two dates. The first indicating the earliest measurement
date and the second indicating the latest possible measurement date.}

\item{checks}{Diagnostics to run. Options are: "measurement_timing",
"measurement_value_as_numeric", and "measurement_value_as_concept".}
}
\value{
A summarised result
}
\description{
Diagnostics of a codelist of measurement codes within a cohort
}
\examples{
\donttest{
library(MeasurementDiagnostics)
cdm <- mockMeasurementDiagnostics()
result <- summariseCohortMeasurementUse(
  codes = list("test_codelist" = c(3001467L, 45875977L)),
  cohort = cdm$my_cohort, timing = "cohort_start_date"
)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
