% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estP.r
\name{estP}
\alias{estP}
\title{Estimate atmospheric pressure (P)}
\usage{
estP(elev, control = list(Tko = 20))
}
\arguments{
\item{elev}{elevation [m]}

\item{control}{list for control parameters and empirical factors defined in
\code{\link{controlDefaults}} and \code{\link{constDefaults}} (see Details)}
}
\value{
atmospheric pressure [kPa]
}
\description{
Values for atmospheric pressure as a function of altitude.
}
\details{
\describe{\item{Control variables:}{}
\item{}{Tko: reference temperature [degreeC] at elevation z0. Often assumed to be 20 degreeC}
\item{}{z0: elevation at reference level [m]}
\item{}{a1: constant lapse rate moist air (0.0065 [K/m])}
\item{}{g: gravitational acceleration (9.807 [m/s2])}
\item{}{R: specific gas constant (287 [J/(kg K)])}}
}
\note{
eq. 3-2 of Reference
}
\examples{
estP(elev = 25, control = list(Tko = 20))
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
