% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sts.R
\name{sts_isValid}
\alias{sts_isValid}
\title{Test \emph{sts} object for correct structure}
\usage{
sts_isValid(sts = NULL, verbose = FALSE)
}
\arguments{
\item{sts}{\emph{sts} object}

\item{verbose}{Logical specifying whether to produce detailed warning messages.}
}
\value{
\code{TRUE} if \code{sts} has the correct structure,
\code{FALSE} otherwise.
}
\description{
The \code{sts} is checked for the presence of core
\code{meta} and \code{data} columns.

Core \code{meta} columns include:

\itemize{
  \item{\code{deviceDeploymentID} -- unique identifier (see \href{https://mazamascience.github.io/MazamaLocationUtils/}{MazmaLocationUtils})}
  \item{\code{deviceID} -- device identifier}
  \item{\code{locationID} -- location identifier (see \href{https://mazamascience.github.io/MazamaLocationUtils/}{MazmaLocationUtils})}
  \item{\code{locationName} -- English language name}
  \item{\code{longitude} -- decimal degrees E}
  \item{\code{latitude} -- decimal degrees N}
  \item{\code{elevation} -- elevation of station in m}
  \item{\code{countryCode} -- ISO 3166-1 alpha-2}
  \item{\code{stateCode} -- ISO 3166-2 alpha-2}
  \item{\code{timezone} -- Olson time zone}
}

Core \code{data} columns include:

\itemize{
  \item{\code{datetime} -- measurement time (UTC)}
}
}
\examples{
library(MazamaTimeSeries)

sts_isValid(example_sts)

}
