% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getState.R
\name{getState}
\alias{getState}
\title{Return state names at specified locations}
\usage{
getState(
  longitude,
  latitude,
  dataset = "NaturalEarthAdm1",
  countryCodes = NULL,
  allData = FALSE,
  useBuffering = FALSE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees East.}

\item{latitude}{Vector of latitudes in decimal degrees North.}

\item{dataset}{Name of spatial dataset to use.}

\item{countryCodes}{Vector of ISO 3166-1 alpha-2 country codes.}

\item{allData}{Logical specifying whether a full dataframe should be returned.}

\item{useBuffering}{Logical flag specifying the use of location buffering to
find the nearest polygon if no target polygon is found.}
}
\value{
Vector of English language state names.
}
\description{
Uses spatial comparison to determine which 'state' polygons the
locations fall into and returns the ISO 3166-2 2-character state code
strings for those polygons.

Specification of \code{countryCodes} limits spatial searching to the
specified countries and greatly improves performance.

If \code{allData = TRUE}, additional data is returned.
}
\examples{
\dontrun{
library(MazamaSpatialUtils)
setSpatialData("~/Data/Spatial")

loadSpatialData("NaturalEarthAdm1")

longitude <- seq(-140, -90)
latitude <- seq(20, 70)
getState(longitude, latitude)
}

}
\seealso{
getSpatialData
}
\keyword{locator}
