% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getNearestDistance.R
\name{table_getNearestDistance}
\alias{table_getNearestDistance}
\title{Return distances to nearest known locations}
\usage{
table_getNearestDistance(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Vector of longitudes in decimal degrees E.}

\item{latitude}{Vector of latitudes in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation.

See \code{geodist::\link[geodist:geodist]{geodist}} for details.}
}
\value{
Vector of distances from known locations.
}
\description{
Returns distances between known locations in \code{locationTbl},
and a vector of target locations specified by \code{longitude} and \code{latitude}.
Only a single distance to the closest known location is returned for each
incoming target location. If no known location is found within
\code{distanceThreshold} meters for a particular
incoming location, that distance in the vector will be \code{NA}.
}
\note{
The measure \code{"cheap"} may be used to speed things up depending on
the spatial scale being considered. Distances calculated with
\code{measure = "cheap"} will vary by a few meters compared with those
calculated using \code{measure = "geodesic"}.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Too small a distanceThreshold will not find a match
table_getNearestDistance(locationTbl, lon, lat, distanceThreshold = 50)

# Expanding the distanceThreshold will find one
table_getNearestDistance(locationTbl, lon, lat, distanceThreshold = 5000)

}
