% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacheManagement.R
\name{manageCache}
\alias{manageCache}
\title{Manage the size of a cache}
\usage{
manageCache(
  cacheDir = NULL,
  extensions = c("html", "json", "pdf", "png"),
  maxCacheSize = 100,
  sortBy = "atime",
  maxFileAge = NULL
)
}
\arguments{
\item{cacheDir}{Location of cache directory.}

\item{extensions}{Vector of file extensions eligible for removal.}

\item{maxCacheSize}{Maximum cache size in megabytes.}

\item{sortBy}{Timestamp to sort by when sorting files eligible for removal.
One of \code{atime|ctime|mtime}.}

\item{maxFileAge}{Maximum age in days of files allowed in the cache.}
}
\value{
Invisibly returns the number of files removed.
}
\description{
If \code{cacheDir} takes up more than \code{maxCacheSize}
megabytes on disk, files will be removed in order of access time by
default. Only files matching \code{extensions} are eligible for removal.
Files can also be removed in order of change time with \code{sortBy='ctime'}
or modification time with \code{sortBy='mtime'}.

The \code{maxFileAge} parameter can also be used to remove files that haven't
been modified in a certain number of days. Fractional days are allowed. This
removal happens without regard to the size of the cache and is useful for
removing out-of-date data.

It is important to understand precisely what these timestamps
represent:
\itemize{
\item{\code{atime} -- File access time: updated whenever a file is opened.}
\item{\code{ctime} -- File change time: updated whenever a file's metadata
changes e.g. name, permission, ownership.}
\item{\code{mtime} -- file modification time: updated whenever a file's
contents change.}
}
}
\examples{
# Create a cache directory and fill it with 1.6 MB of data
CACHE_DIR <- tempdir()
write.csv(matrix(1,400,500), file=file.path(CACHE_DIR,'m1.csv'))
write.csv(matrix(2,400,500), file=file.path(CACHE_DIR,'m2.csv'))
write.csv(matrix(3,400,500), file=file.path(CACHE_DIR,'m3.csv'))
write.csv(matrix(4,400,500), file=file.path(CACHE_DIR,'m4.csv'))
for (file in list.files(CACHE_DIR, full.names=TRUE)) {
  print(file.info(file)[,c(1,6)])
}

# Remove files based on access time until we get under 1 MB
manageCache(CACHE_DIR, extensions='csv', maxCacheSize=1, sortBy='atime')
for (file in list.files(CACHE_DIR, full.names=TRUE)) {
  print(file.info(file)[,c(1,6)])
}

# Or remove files based on modification time
manageCache(CACHE_DIR, extensions='csv', maxCacheSize=1, sortBy='mtime')
for (file in list.files(CACHE_DIR, full.names=TRUE)) {
  print(file.info(file)[,c(1,6)])
}
}
