% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R
\name{rbind_csr}
\alias{rbind_csr}
\title{Concatenate inputs by rows into a CSR matrix}
\usage{
rbind_csr(...)
}
\arguments{
\item{...}{Inputs to concatenate. The function is aimed at CSR matrices (`dgRMatrix`,
`ngRMatrix`, `lgRMatrix`) and sparse vectors (`sparseVector`). It will work with other classes
(such as `dgCMatrix`) but will not be as efficient.}
}
\value{
A CSR matrix (class `dgRMatrix`, `lgRMatrix`, or `ngRMatrix` depending on the inputs) with
the inputs concatenated by rows.
}
\description{
Concatenate two or more matrices and/or vectors by rows, giving a CSR matrix
as result.

This is aimed at concatenating several CSR matrices or sparse vectors at a time,
as it will be faster than calling `rbind` which will only concatenate one at a
time, resulting in unnecessary allocations.
}
\details{
This function will not preserve the column names, if any were present.
}
\examples{
library(Matrix)
library(MatrixExtra)
v <- as(1:10, "sparseVector")
rbind_csr(v, v, v)

X <- matrix(1:20, nrow=2)
rbind_csr(X, v)
}
\seealso{
\link{rbind2-method}
}
