% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAcv.R
\name{PCAimpute}
\alias{PCAimpute}
\title{Principal Component Analysis based imputation}
\usage{
PCAimpute(X, ncomp, center = TRUE, max_iter = 20, tol = 10^-5)
}
\arguments{
\item{X}{\code{matrix} object to perform PCA on.}

\item{ncomp}{\code{integer} number of components.}

\item{center}{\code{logical} indicating if centering (default) should be performed.}

\item{max_iter}{\code{integer} number of iterations of PCA if sum of squared
change in imputed values is above \code{tol}.}

\item{tol}{\code{numeric} tolerance for sum of squared cange in imputed values.}
}
\value{
Final singular value decomposition, imputed \code{X} matrix and
convergence metrics (sequence of sum of squared change and number of iterations).
}
\description{
Imputation of missing data, NA, using Principal Component Analysis with
iterative refitting and mean value updates. The chosen number of components
and convergence parameters (iterations and tolerance) influence the
precision of the imputation.
}
\examples{
X <- matrix(rnorm(12),3,4)
X[c(2,6,10)] <- NA
PCAimpute(X, 3)
}
