% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebuild-model-matrix.R
\name{add_model_matrix}
\alias{add_model_matrix}
\title{Rebuilds the model matrix for MatchIt objects}
\usage{
add_model_matrix(fit)
}
\arguments{
\item{fit}{MatchIt Object}
}
\value{
MatchIt Object with added model matrix
}
\description{
In order to use estimate Standard Errors with the Abadie and Imben's method
the MatchIt object needs to have a model matrix. The model matrix is created
based on the subclasses given by the full matching procedure.
}
\details{
This function is experimental! Most methods for estimating standard errors
are only documented for NN matching. Please use with caution!
}
\examples{
\dontrun{
library(MatchIt)
data('lalonde')
m.out  <- matchit(treat ~ educ + black, data = lalonde, method = 'full')
att(obj = m.out, Y = lalonde$re78)
abadie_imbens_se(m.out, lalonde$re78)  # FAILS!
m.out <- add_model_matrix(m.out)
abadie_imbens_se(m.out, lalonde$re78)
}
}

