% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Abadie-Imbens-SE.R
\name{abadie_imbens_se}
\alias{abadie_imbens_se}
\title{Abadie Imben's Standard Error for the ATT}
\usage{
abadie_imbens_se(obj, Y)
}
\arguments{
\item{obj}{MatchIt Object}

\item{Y}{Response Vector}
}
\value{
SE for the ATT of \code{Y}
}
\description{
Calculate the SE for the ATT with Abadie & Imben's method.
}
\examples{
\dontrun{
  library(MatchIt)
  data("lalonde")
  m.out  <- matchit(treat ~ educ + black, data = lalonde)
  att(obj = m.out, Y = lalonde$re78)
  abadie_imbens_se(obj = m.out, Y = lalonde$re78)
}
}
\references{
Abadie, A., Drukker, D., Herr, J.L. & Imbens, G. (2004).Implementing matching estimators for average treatment effects in Stata. The Stata Jorunal (4), pp. 290 - 311.
}

