% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.mimids}
\alias{is.mimids}
\title{Checks for the \code{mimids} Class}
\usage{
is.mimids(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if is of the \code{mimids} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{mimids} class.
}
\description{
The \code{is.mimids()} function checks whether class of objects are \code{mimids} or not.
}
\details{
The class of objects are checked to be of the \code{mimids}.
}
\examples{
\donttest{
#Loading the 'dt.osa' dataset
data(dt.osa)

#Imputing missing data points in the'dt.osa' dataset
datasets <- mice(dt.osa, m = 5, maxit = 1,
                 method = c("", "", "mean", "", "polyreg", "logreg", "logreg"))

#Matching the imputed datasets, 'datasets'
matcheddatasets <- matchitmice(KOA ~ SEX + AGE + SMK, datasets,
                               approach = 'within', method = 'exact')

#Checking the 'matcheddatasets' object
is.mimids(matcheddatasets)
is(matcheddatasets)
}
}
\seealso{
\code{\link[=matchitmice]{matchitmice}}

\code{\link[=mimids]{mimids}}
}
\author{
Farhad Pishgar
}
\keyword{function}
