% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchitmice.data.R
\name{matchitmice.data}
\alias{matchitmice.data}
\title{Outputs Matched Imputed Datasets}
\usage{
matchitmice.data(object, n = 1)
}
\arguments{
\item{object}{This argument specifies an object of the \code{mimids} class.}

\item{n}{This argument specifies number of the matched imputed dataset intended to extract its matching data. The input must be a positive integer. The default is \code{1}.}
}
\value{
This function returns a subset of the imputed dataset sent to \code{matchitmice()} with just the matched individuals.
}
\description{
The \code{matchitmice.data()} function extracts matching data from an object of the \code{mimids} class.
}
\details{
The matched dataset of a \code{mimids} class object is extracted.
}
\examples{
\donttest{
#Please see the package repository <https://github.com/FarhadPishgar/MatchIt.mice> for details.

#Loading the 'handoa' dataset
data(handoa)

#Imputing the missing data points in the 'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 1,
                 method = c("", "", "", "mean", "polyreg", "logreg", "", ""))

#Matching the imputed datasets, 'datasets'
matcheddatasets <- matchitmice(HANDOA ~ SEX + AGE, datasets)

#Extracting data of the first imputed dataset
data1 <- matchitmice.data(matcheddatasets, n = 1)
}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=mimids]{mimids}}
}
\author{
Farhad Pishgar
}
