% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_kmeans.R
\name{step_kmeans}
\alias{step_kmeans}
\alias{tidy.step_kmeans}
\alias{tunable.step_kmeans}
\title{K-Means Clustering Variable Reduction}
\usage{
step_kmeans(
  recipe,
  ...,
  k = 5,
  center = TRUE,
  scale = TRUE,
  algorithm = c("Hartigan-Wong", "Lloyd", "Forgy", "MacQueen"),
  max_iter = 10,
  num_start = 1,
  replace = TRUE,
  prefix = "KMeans",
  role = "predictor",
  skip = FALSE,
  id = recipes::rand_id("kmeans")
)

\method{tidy}{step_kmeans}(x, ...)

tunable.step_kmeans(x, ...)
}
\arguments{
\item{recipe}{\link[recipes]{recipe} object to which the step will be added.}

\item{...}{one or more selector functions to choose which variables will be
used to compute the components.  See \code{\link[recipes]{selections}} for
more details.  These are not currently used by the \code{tidy} method.}

\item{k}{number of k-means clusterings of the variables.  The value of
\code{k} is constrained to be between 1 and one less than the number of
original variables.}

\item{center, scale}{logicals indicating whether to mean center and standard
deviation scale variables prior to clustering and averaging.}

\item{algorithm}{character string specifying the clustering algorithm to use.}

\item{max_iter}{maximum number of algorithm iterations allowed.}

\item{num_start}{number of random cluster centers generated for starting the
Hartigan-Wong algorithm.}

\item{replace}{logical indicating whether to replace the original variables.}

\item{prefix}{character string prefix added to a sequence of zero-padded
integers to generate names for the resulting new variables.}

\item{role}{analysis role that added step variables should be assigned.  By
default, they are designated as model predictors.}

\item{skip}{logical indicating whether to skip the step when the recipe is
baked.  While all operations are baked when \code{\link[recipes]{prep}} is
run, some operations may not be applicable to new data (e.g. processing
outcome variables).  Care should be taken when using \code{skip = TRUE} as
it may affect the computations for subsequent operations.}

\item{id}{unique character string to identify the step.}

\item{x}{\code{step_kmeans} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any).  For the \code{tidy} method, a tibble
with columns \code{terms} (selectors or variables selected), \code{cluster}
assignments, \code{sqdist} (squared distance from cluster centers), and
\code{names} of the new variables.
}
\description{
Creates a \emph{specification} of a recipe step that will convert numeric
variables into one or more by averaging within k-means clusters.
}
\details{
K-means clustering partitions variables into k groups such that the sum of
squares between the variables and their assigned cluster means is minimized.
Variables within each cluster are then averaged to derive a new set of k
variables.
}
\examples{
library(recipes)

rec <- recipe(rating ~ ., data = attitude)
kmeans_rec <- rec \%>\%
  step_kmeans(all_predictors(), k = 3)
kmeans_prep <- prep(kmeans_rec, training = attitude)
kmeans_data <- bake(kmeans_prep, attitude)

pairs(kmeans_data, lower.panel = NULL)

tidy(kmeans_rec, number = 1)
tidy(kmeans_prep, number = 1)

}
\references{
Forgy EW (1965). Cluster analysis of multivariate data: efficiency vs
interpretability of classifications. Biometrics 21, 768--769.

Hartigan JA and Wong MA (1979). A K-means clustering algorithm.  Applied
Statistics 28, 100--108.

Lloyd SP (1957, 1982). Least squares quantization in PCM. Technical Note,
Bell Laboratories. Published in 1982 in IEEE Transactions on Information
Theory 28, 128--137.

MacQueen J (1967). Some methods for classification and analysis of
multivariate observations. In Proceedings of the Fifth Berkeley Symposium
on Mathematical Statistics and Probability, eds L. M. Le Cam & J. Neyman,
1, 281--297. Berkeley, CA: University of California Press.
}
\seealso{
\code{\link[stats]{kmeans}}, \code{\link[recipes]{recipe}},
\code{\link[recipes]{prep}}, \code{\link[recipes]{bake}}
}
