% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.MLModelFit}
\title{Model Prediction}
\usage{
\method{predict}{MLModelFit}(
  object,
  newdata = NULL,
  times = NULL,
  type = c("response", "prob"),
  cutoff = MachineShop::settings("cutoff"),
  dist = NULL,
  method = NULL,
  ...
)
}
\arguments{
\item{object}{model \link{fit} result.}

\item{newdata}{optional \link[=data.frame]{data frame} with which to obtain
predictions.  If not specified, the training data will be used by default.}

\item{times}{numeric vector of follow-up times at which to predict
survival events/probabilities or \code{NULL} for predicted survival means.}

\item{type}{specifies prediction on the original outcome scale
(\code{"response"}) or on a probability distribution scale (\code{"prob"}).}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.}

\item{dist}{character string specifying distributional approximations to
estimated survival curves.  Possible values are \code{"empirical"},
\code{"exponential"}, \code{"rayleigh"}, or \code{"weibull"}; with defaults
of \code{"empirical"} for predicted survival events/probabilities and
\code{"weibull"} for predicted survival means.}

\item{method}{character string specifying the empirical method of estimating
baseline survival curves for Cox proportional hazards-based models.
Choices are \code{"breslow"}, \code{"efron"} (default), or
\code{"fleming-harrington"}.}

\item{...}{arguments passed to model-specific prediction functions.}
}
\description{
Predict outcomes with a fitted model.
}
\examples{
## Survival response example
library(survival)
library(MASS)

gbm_fit <- fit(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
               data = Melanoma, model = GBMModel)
predict(gbm_fit, newdata = Melanoma, times = 365 * c(2, 5, 10), type = "prob")

}
\seealso{
\code{\link{confusion}}, \code{\link{performance}},
\code{\link{metrics}}
}
