% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_RPartModel.R
\name{RPartModel}
\alias{RPartModel}
\title{Recursive Partitioning and Regression Tree Models}
\usage{
RPartModel(minsplit = 20, minbucket = round(minsplit/3), cp = 0.01,
  maxcompete = 4, maxsurrogate = 5, usesurrogate = 2, xval = 10,
  surrogatestyle = 0, maxdepth = 30)
}
\arguments{
\item{minsplit}{minimum number of observations that must exist in a node in
order for a split to be attempted.}

\item{minbucket}{minimum number of observations in any terminal node.}

\item{cp}{complexity parameter.}

\item{maxcompete}{number of competitor splits retained in the output.}

\item{maxsurrogate}{number of surrogate splits retained in the output.}

\item{usesurrogate}{how to use surrogates in the splitting process.}

\item{xval}{number of cross-validations.}

\item{surrogatestyle}{controls the selection of a best surrogate.}

\item{maxdepth}{maximum depth of any node of the final tree, with the root
node counted as depth 0.}
}
\value{
\code{MLModel} class object.
}
\description{
Fit an \code{rpart} model.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}, \code{Surv}}
\item{\link[=tune]{Automatic Tuning} Grid Parameters:}{
\code{cp}
}
}

Further model details can be found in the source link below.
}
\examples{
fit(Species ~ ., data = iris, model = RPartModel())

}
\seealso{
\code{\link[rpart]{rpart}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
