% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFrame.R
\name{ModelFrame}
\alias{ModelFrame}
\alias{ModelFrame.formula}
\alias{ModelFrame.matrix}
\title{ModelFrame Class}
\usage{
ModelFrame(x, ...)

\method{ModelFrame}{formula}(x, data, na.rm = TRUE, weights = NULL,
  strata = NULL, ...)

\method{ModelFrame}{matrix}(x, y = NULL, na.rm = TRUE,
  weights = NULL, strata = NULL, ...)
}
\arguments{
\item{x}{model \code{\link{formula}} or \code{matrix} of predictor variables.}

\item{...}{arguments passed to other methods.}

\item{data}{\code{data.frame} or an object that can be converted to one.}

\item{na.rm}{logical indicating whether to remove cases with \code{NA} values}

\item{weights}{vector of case weights.}

\item{strata}{vector of stratification levels.
for any of the model variables.}

\item{y}{response variable.}
}
\value{
\code{ModelFrame} class object that inherits from \code{data.frame}.
}
\description{
Class for storing data, formulas, and other attributes for fitting MLModels.
}
\examples{
mf <- ModelFrame(ncases / (ncases + ncontrols) ~ agegp + tobgp + alcgp,
                 data = esoph, weights = with(esoph, ncases + ncontrols))
gbmfit <- fit(mf, model = GBMModel)
varimp(gbmfit)

}
\seealso{
\code{\link{formula}}
}
