% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/confusion.R
\name{confusion}
\alias{confusion}
\alias{Confusion}
\title{Confusion Matrix}
\usage{
Confusion(...)

confusion(x, y = NULL, cutoff = 0.5, ...)
}
\arguments{
\item{...}{named or unnamed \code{confusion} output to combine together with
the \code{Confusion} constructor.}

\item{x}{factor of observed responses or \code{Resamples} object of observed
and predicted responses.}

\item{y}{predicted responses.}

\item{cutoff}{threshold above which probabilities are classified as success
for binary responses.  If \code{NULL}, then responses are summed directly
over predicted class probabilities and will thus appear as decimal numbers
that can be interpreted as expected counts.}
}
\value{
The return value is a \code{ConfusionMatrix} class object that inherits from
\code{table} if \code{x} and \code{y} responses are specified or a
\code{ConfusionResamples} object that inherits from \code{list} if \code{x}
is a \code{Resamples} object.
}
\description{
Calculate confusion matrices of predicted and observed responses.
}
\examples{
res <- resample(Species ~ ., data = iris, model = GBMModel)
confusion(res)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{plot}}, \code{\link{summary}}
}
