% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvShapiro.R
\name{mvShapiro}
\alias{mvShapiro}
\title{Multivariate Shapiro-Wilk Test for Multivariate Normality}
\usage{
mvShapiro(data, group = FALSE, G = NULL)
}
\arguments{
\item{data}{a data frame.}

\item{group}{a logical argument. If \code{group="TRUE"}, the normality 
tests are performed for the groups in data.
When \code{group=TRUE}, \code{G=NULL} cannot be. default 
\code{group="FALSE"}}

\item{G}{a group vector. default \code{G=NULL}}
}
\value{
a list with 2 elements:
\item{Stat}{The value of Test Statistic(s)}
\item{p.value}{p value(s)}
}
\description{
\code{mvShapiro} function tests whether the data set has multivariate 
normality distribution or not.
}
\details{
This function computes the test statistic and p-value of the Shapiro-Wilk
test for multivariate normality proposed by Villasenor-Alva and
GonzalezEstrada (2009). Moreover, it can perform normality test for all
groups in grouped datasets. The hypotheses are defined as H0:The dataset comes
from multivariate normal distribution and H1:The dataset does not
come from multivariate normal distribution.
}
\examples{

data(iris) 
# For raw data
result <- mvShapiro(data=iris[,1:4])
summary(result)
#For grouped data
result.group <- mvShapiro(data=iris[,1:4],group=TRUE,G=iris[,5])
summary(result.group)
}
\references{
Villasenor Alva, J. A., & Estrada, E. G. (2009). 
A generalization of Shapiro Wilk's test for multivariate normality. 
Communications in Statistics Theory and Methods, 38(11), 1870-1883.

Elizabeth Gonzalez Estrada and Jose A. Villasenor-Alva (2013).
mvShapiroTest: Generalized Shapiro Wilk test for multivariate   normality.
R package version 1.0.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
