% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mpaired.R
\name{Mpaired}
\alias{Mpaired}
\title{Multivariate Paired Test}
\usage{
Mpaired(T1, T2)
}
\arguments{
\item{T1}{The first treatment data.}

\item{T2}{The second treatment data.}
}
\value{
a list with 7 elements:
\item{HT2}{The value of Hotelling T^2 Test Statistic}
\item{F}{The value of F Statistic}
\item{df}{The F statistic's degree of freedom}
\item{p.value}{p value}
\item{Descriptive1}{The descriptive statistics of the first treatment}
\item{Descriptive2}{The descriptive statistics of the second treatment}
\item{Descriptive.Difference}{The descriptive statistics of the differences}
}
\description{
\code{Mpaired} function computes the value of test statistic based on 
Hotelling T Square 
approach in multivariate paired data sets.
}
\details{
This function computes one sample Hotelling T^2 statistics for paired 
data sets.
}
\examples{

data(Coated)
X<-Coated[,2:3]; Y<-Coated[,4:5]
result <- Mpaired(T1=X,T2=Y)
summary(result)
}
\references{
Rencher, A. C. (2003). Methods of multivariate analysis 
(Vol. 492). John Wiley & Sons.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
