% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTAFT_simdata.R
\name{MTAFT_simdata}
\alias{MTAFT_simdata}
\title{Generate simulated data for MTAFT analysis.}
\usage{
MTAFT_simdata(n, err = c("normal", "t3"))
}
\arguments{
\item{n}{The number of sample size.}

\item{err}{The error distribution type, either "normal" or "t3".}
}
\value{
A dataset containing the simulated data for MTAFT analysis.
}
\description{
This function generates simulated data for the MTAFT (Multi-Threshold Accelerated Failure Time) analysis based on a simple simulation procedure described in the article.
}
\examples{
# Generate simulated data with 500 samples and normal error distribution
dataset <- MTAFT_simdata(n = 500, err = "normal")
Y <- dataset[, 1]
delta <- dataset[, 2]
Tq <- dataset[, 3]
X <- dataset[, -c(1:3)]

# Generate simulated data with 200 samples and t3 error distribution
dataset <- MTAFT_simdata(n = 200, err = "t3")
Y <- dataset[, 1]
delta <- dataset[, 2]
Tq <- dataset[, 3]
X <- dataset[, -c(1:3)]
}
