% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\name{Sim}
\alias{Sim}
\alias{Sim.MSGARCH_SPEC}
\alias{Sim.MSGARCH_ML_FIT}
\alias{Sim.MSGARCH_MCMC_FIT}
\title{Simulation of MSGARCH processes.}
\usage{
Sim(object, ...)

\method{Sim}{MSGARCH_SPEC}(object, data = NULL, n.ahead = 1L, n.sim = 1L,
  par = NULL, n.burnin = 500L, ...)

\method{Sim}{MSGARCH_ML_FIT}(object, new.data = NULL, n.ahead = 1L,
  n.sim = 1L, n.burnin = 500L, ...)

\method{Sim}{MSGARCH_MCMC_FIT}(object, new.data = NULL, n.ahead = 1L,
  n.sim = 1L, n.burnin = 500L, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{CreateSpec}}
or fit object of type \code{MSGARCH_ML_FIT} created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{Sim}.}

\item{data}{Vector (of size T) of observations for filtering.}

\item{n.ahead}{Simulation length. (Default: \code{n.ahead = 1L})}

\item{n.sim}{Number of simulations. (Default: \code{n.sim = 1L})}

\item{par}{Vector (of size d) or matrix (of size \code{n.ahead} x d) of parameter
estimates where d must have
the same length as the default parameters of the specification.}

\item{n.burnin}{Burnin period discarded (first simulation draws).
Not used when \code{data} is provided. (Default: \code{n.burnin = 500L})}

\item{new.data}{Vector (of size T*) of new observations.. (Default \code{new.data = NULL})}
}
\value{
A list of class \code{MSGARCH_SIM} with the following elements:.
\itemize{
\item \code{draw}: Matrix (of size \code{n.ahead} x \code{n.sim}) of simulated draws.
\item \code{state}: Matrix (of size \code{n.ahead} x \code{n.sim}) of simulated states.
\item \code{CondVol}: Array (of size \code{n.ahead} x \code{n.sim} x K) of simulated conditional volatility.  
}
The \code{MSGARCH_SIM} class contains the \code{plot} method.
}
\description{
Method for simulating \code{MSGARCH} processes.
}
\details{
If a matrix of parameters estimates is provided, \code{n.sim} simuations will be done for each row..
When \code{data} is provided, the conditional variance and state probability are update up to time \code{T + T* + 1}
before beginning the simulations.
If \code{data = NULL}, new simulations will start from scratch where the
first \code{n.burnin} simulation will be discarded.
Passing a \code{MSGARCH_ML_FIT} or \code{MSGARCH_MCMC_FIT} object
will automatically filter the corresponding
\code{data} in the object and start the simulation ahead of \code{data}.
}
\examples{
# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# generate process
par.sim <- c(0.1,0.6,0.2,0.2,0.8,0.1,0.99,0.01)
set.seed(123)
sim <- Sim(object = spec, n.ahead = 1000L, n.sim = 1L, par = par.sim, n.burnin = 500L)
plot(sim)

# generate process after filtering for fitted model
# load data
data("SMI", package = "MSGARCH")

# fit the model on the data with ML estimation
fit <- FitML(spec = spec, data = SMI)

set.seed(123)
sim <- Sim(fit, n.ahead = 30L, n.sim = 1000L)
plot(sim)
}
